/*************************************************
 * Auto generated C file from Searduino template file
 *  
 *    
 *  
 */

#include <Arduino.h>
#include "searduino.h"
#include "binary/binary.h"
#include "vu_meter/vu_meter.h"


#define DEBOUNCE 50 /* to stop the button from switching multiple times in one press due to internal 'bounce' */
#define sensorPin A5
#define button 12

long sensorInput = 0;
byte sensorValue = 0; /* byte is a typedef, making it more portable to the Arduino API */

/* pseudo-boolean variables */
byte buttonState = 0;
byte VALID_TOGGLE = 1; /* makes sure the mode doesn't jump back and forth when button held */
byte mode = 0;


void
setup(void)
{
  pinMode(button, INPUT);
  
  /* iteratively sets pins 2-9 to output mode */
  byte thisPin; 
  for (thisPin = 2; thisPin <= 9; thisPin++)
    {
      pinMode(thisPin, OUTPUT);
    }
}

void loop(void) {
  sensorInput = analogRead(sensorPin);
    
  sensorValue = (sensorInput * 255) /1023; /* basically arduinos own map() function with hardcoded values as the analog input never exceeds 1023 */

 /* both boolean conditions must be met in order for a button press to register   */
 /* this prevents the program from registering multiple button presses when the button is held down */ 
  buttonState = digitalRead(button);
  if (buttonState == HIGH && VALID_TOGGLE == 1)
    {
      mode = !mode;
      VALID_TOGGLE = !VALID_TOGGLE;
      delay(DEBOUNCE);
    }
  else if (buttonState == LOW && VALID_TOGGLE == 0)
    {
      VALID_TOGGLE = !VALID_TOGGLE;
      delay(DEBOUNCE);
    }
  
  
  if (mode == 0)
    {
      binary(sensorValue);
    }
  else if (mode == 1)
    {
      vu_meter(sensorValue);
    }
}


int
main (void)
{
  
  init();
  setup();
  
  /* The following line uses a Saerduino macro 
   * You could use a plain "for (;;)" instead
   */
  SEARDUINO_LOOP()
    {
      loop();
    }
}

/*** End of auto generated code ***/


